@echo off
title CLSTEAM MEMORY OPTIMIZER - Ultimate RAM Performance
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM MEMORY OPTIMIZER - ULTIMATE RAM PERFORMANCE
echo ===============================================
echo.
echo Starting memory optimization process...
echo.
timeout /t 2 /nobreak >nul

:: Detect Memory Information
echo [1/32] Detecting Memory Configuration...
echo.
wmic MEMORYCHIP get BankLabel, Capacity, Speed, MemoryType /format:table > %temp%\memory_info.txt 2>nul
wmic OS get TotalVisibleMemorySize, FreePhysicalMemory /format:value > %temp%\memory_stats.txt 2>nul

set /a total_memory=0
set /a free_memory=0
set /a total_gb=0
set /a free_gb=0

for /f "tokens=2 delims==" %%i in ('type "%temp%\memory_stats.txt" ^| findstr "TotalVisibleMemorySize"') do set /a total_memory=%%i
for /f "tokens=2 delims==" %%i in ('type "%temp%\memory_stats.txt" ^| findstr "FreePhysicalMemory"') do set /a free_memory=%%i

set /a total_gb=%total_memory%/1048576
set /a free_gb=%free_memory%/1048576
set /a used_gb=%total_gb%-%free_gb%

echo Total Physical Memory: %total_gb% GB
echo Currently Used: %used_gb% GB
echo Currently Free: %free_gb% GB
echo.
type "%temp%\memory_info.txt" 2>nul
echo.
timeout /t 3 /nobreak >nul

:: Large System Cache Enable
echo [2/32] Enabling Large System Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "LargeSystemCache" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Large system cache enabled for server workloads
echo [SUCCESS] Large system cache configured
echo.

:: Disable Paging Executive
echo [3/32] Disabling Paging Executive...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisablePagingExecutive" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Kernel and drivers kept in RAM
echo [SUCCESS] Paging executive disabled
echo.

:: Clear Page File at Shutdown
echo [4/32] Optimizing Page File Management...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ClearPageFileAtShutdown" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file clearing disabled for faster shutdown
echo [SUCCESS] Page file management optimized
echo.

:: I/O Page Lock Limit
echo [5/32] Increasing I/O Page Lock Limit...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "IOPageLockLimit" /t REG_DWORD /d 4194304 /f >nul 2>&1 && echo   - I/O page lock limit set to 4GB
echo [SUCCESS] I/O page lock limit increased
echo.

:: Non Paged Pool Size
echo [6/32] Optimizing Non-Paged Pool Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "NonPagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Non-paged pool size set to system managed
echo [SUCCESS] Non-paged pool optimized
echo.

:: Paged Pool Size
echo [7/32] Optimizing Paged Pool Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Paged pool size set to system managed
echo [SUCCESS] Paged pool optimized
echo.

:: System Pages
echo [8/32] Increasing System Pages...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SystemPages" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System pages set to maximum available
echo [SUCCESS] System pages optimized
echo.

:: Prefetcher Optimization
echo [9/32] Optimizing Prefetcher...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnablePrefetcher" /t REG_DWORD /d 3 /f >nul 2>&1 && echo   - Prefetcher enabled for apps and boot
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnableSuperfetch" /t REG_DWORD /d 3 /f >nul 2>&1 && echo   - Superfetch enabled
echo [SUCCESS] Prefetcher and Superfetch optimized
echo.

:: Superfetch Configuration
echo [10/32] Configuring Superfetch...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "SuperfetchOnSSD" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Superfetch optimized for SSD
echo [SUCCESS] Superfetch configuration completed
echo.

:: Memory Compression Disable
echo [11/32] Disabling Memory Compression...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisableMemoryCompression" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Memory compression disabled for performance
echo [SUCCESS] Memory compression disabled
echo.

:: Trim Memory on Standby
echo [12/32] Optimizing Standby Memory...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "TrimUnusedCells" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Standby memory trimming enabled
echo [SUCCESS] Standby memory optimized
echo.

:: Session Pool Size
echo [13/32] Increasing Session Pool Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionPoolSize" /t REG_DWORD /d 4096 /f >nul 2>&1 && echo   - Session pool size increased
echo [SUCCESS] Session pool size optimized
echo.

:: Session View Size
echo [14/32] Optimizing Session View Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionViewSize" /t REG_DWORD /d 128 /f >nul 2>&1 && echo   - Session view size optimized
echo [SUCCESS] Session view size configured
echo.

:: Dynamic Memory Management
echo [15/32] Enabling Dynamic Memory...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\NTDS\Parameters" /v "DynamicMemory" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Dynamic memory management enabled
echo [SUCCESS] Dynamic memory enabled
echo.

:: Pool Usage Maximum
echo [16/32] Setting Pool Usage Maximum...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PoolUsageMaximum" /t REG_DWORD /d 80 /f >nul 2>&1 && echo   - Pool usage maximum set to 80%%
echo [SUCCESS] Pool usage maximum configured
echo.

:: Virtual Memory Management
echo [17/32] Optimizing Virtual Memory...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SecondLevelDataCache" /t REG_DWORD /d 512 /f >nul 2>&1 && echo   - Second level data cache optimized
echo [SUCCESS] Virtual memory management enhanced
echo.

:: DMA Buffer Size
echo [18/32] Increasing DMA Buffer Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DmaBufferSize" /t REG_DWORD /d 64 /f >nul 2>&1 && echo   - DMA buffer size increased
echo [SUCCESS] DMA buffer size optimized
echo.

:: Write Combining
echo [19/32] Enabling Write Combining...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "WriteCombining" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Write combining enabled for graphics
echo [SUCCESS] Write combining enabled
echo.

:: Physical Address Extension
echo [20/32] Optimizing Physical Address Extension...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PhysicalAddressExtension" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - PAE enabled for memory above 4GB
echo [SUCCESS] Physical address extension optimized
echo.

:: NonPagedPoolQuota
echo [21/32] Setting Non-Paged Pool Quota...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "NonPagedPoolQuota" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Non-paged pool quota set to system managed
echo [SUCCESS] Non-paged pool quota configured
echo.

:: PagedPoolQuota
echo [22/32] Setting Paged Pool Quota...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagedPoolQuota" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Paged pool quota set to system managed
echo [SUCCESS] Paged pool quota configured
echo.

:: Heap Management Optimization
echo [23/32] Optimizing Heap Management...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager" /v "HeapDeCommitFreeBlockThreshold" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Heap decommit threshold optimized
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager" /v "HeapSegmentReserve" /t REG_DWORD /d 4096 /f >nul 2>&1 && echo   - Heap segment reserve increased
echo [SUCCESS] Heap management optimized
echo.

:: Terminal Server Memory Optimization
echo [24/32] Enabling Terminal Server Memory Mode...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionImageSize" /t REG_DWORD /d 64 /f >nul 2>&1 && echo   - Session image size optimized
echo [SUCCESS] Terminal server memory mode enabled
echo.

:: Memory Priority Configuration
echo [25/32] Setting Memory Priority...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\PriorityControl" /v "MemoryPriority" /t REG_DWORD /d 5 /f >nul 2>&1 && echo   - Memory priority set to high
echo [SUCCESS] Memory priority configured
echo.

:: Cache Working Set Optimization
echo [26/32] Optimizing Cache Working Set...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "LargePageMinimum" /t REG_DWORD /d 4194304 /f >nul 2>&1 && echo   - Large page minimum set
echo [SUCCESS] Cache working set optimized
echo.

:: Mapped File I/O Optimization
echo [27/32] Optimizing Mapped File I/O...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "MappedFileLimit" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Mapped file limit removed
echo [SUCCESS] Mapped file I/O optimized
echo.

:: System Cache Working Set
echo [28/32] Optimizing System Cache Working Set...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SystemCacheWsMinimum" /t REG_DWORD /d 16384 /f >nul 2>&1 && echo   - System cache working set minimum increased
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SystemCacheWsMaximum" /t REG_DWORD /d 131072 /f >nul 2>&1 && echo   - System cache working set maximum increased
echo [SUCCESS] System cache working set optimized
echo.

:: Process Working Set Optimization
echo [29/32] Optimizing Process Working Set...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ProcessWsMinimum" /t REG_DWORD /d 512 /f >nul 2>&1 && echo   - Process working set minimum optimized
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ProcessWsMaximum" /t REG_DWORD /d 4096 /f >nul 2>&1 && echo   - Process working set maximum optimized
echo [SUCCESS] Process working set optimized
echo.

:: Clear Standby Memory (Optional - Run on demand)
echo [30/32] Creating Standby Memory Cleaner...
echo @echo off > "%TEMP%\ClearStandby.bat"
echo echo Clearing Standby Memory... >> "%TEMP%\ClearStandby.bat"
echo powershell -Command "Add-Type -TypeDefinition '\using System; using System.Runtime.InteropServices; public class MemoryCleaner { [DllImport(\"\"psapi.dll\"\")] public static extern int EmptyWorkingSet(IntPtr hProcess); }'; (Get-Process).ForEach({ try { MemoryCleaner::EmptyWorkingSet(\$_.Handle) } catch {} })" >> "%TEMP%\ClearStandby.bat"
echo echo Standby Memory Cleared! >> "%TEMP%\ClearStandby.bat"
echo pause >> "%TEMP%\ClearStandby.bat"
echo [SUCCESS] Standby memory cleaner created at %TEMP%\ClearStandby.bat
echo.

:: Final Memory Flush
echo [31/32] Performing Final Memory Optimization...
rundll32.exe advapi32.dll,ProcessIdleTasks >nul 2>&1 && echo   - Idle tasks processed
echo [SUCCESS] Final memory optimization completed
echo.

:: Cleanup Temporary Files
echo [32/32] Cleaning Temporary Files...
del /q /f %temp%\memory_info.txt >nul 2>&1
del /q /f %temp%\memory_stats.txt >nul 2>&1
echo [SUCCESS] Temporary files cleaned
echo.

:: Completion Message
echo ===============================================
echo    MEMORY OPTIMIZATION COMPLETE!
echo ===============================================
echo.
echo All memory optimizations have been successfully applied!
echo.
echo Summary of memory optimizations performed:
echo ✓ Large system cache enabled
echo ✓ Paging executive disabled
echo ✓ Page file management optimized
echo ✓ I/O page lock limit increased
echo ✓ Prefetcher and Superfetch enhanced
echo ✓ Memory compression disabled for performance
echo ✓ Standby memory trimming enabled
echo ✓ Pool sizes optimized
echo ✓ Virtual memory management enhanced
echo ✓ DMA buffer size increased
echo ✓ Write combining enabled
echo ✓ Physical address extension optimized
echo ✓ Heap management improved
echo ✓ Memory priority set to high
echo ✓ Cache working set optimized
echo ✓ System cache working set increased
echo ✓ Process working set optimized
echo ✓ Standby memory cleaner created
echo.
echo Immediate benefits you'll experience:
echo - Faster application loading times
echo - Reduced memory-related stuttering
echo - Improved gaming performance
echo - Better multitasking capabilities
echo - Reduced disk swapping
echo - Overall system responsiveness improved
echo.
echo Additional Tools Created:
echo - %TEMP%\ClearStandby.bat : Run this to clear standby memory when needed
echo.
echo IMPORTANT: Restart your computer for all changes to take full effect!
echo.
echo CLSTEAM MEMORY OPTIMIZER
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit